<?php

namespace Database\Factories;

use App\Enums\MemberRatingType;
use App\Models\Review;
use App\Models\ReviewRating;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Review>
 */
class ReviewFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Review::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'uuid' => Str::uuid(),
            'review_rating' => $this->faker->numberBetween(1, 5),
            'review_title' => $this->faker->sentence(),
            'review_content' => $this->faker->paragraphs(3, true),
            'review_user_id' => User::inRandomOrder()->first()?->id ?? 1,
            'status' => true,
        ];
    }

    /**
     * Configure the model factory.
     */
    public function configure(): static
    {
        return $this->afterCreating(function (Review $review) {
            // Create all the required rating types for this review
            foreach (MemberRatingType::cases() as $ratingType) {
                $review->ratings()->create([
                    'rating_type' => $ratingType,
                    'rating' => $this->faker->numberBetween(1, 5),
                ]);
            }
        });
    }
}
