<?php

namespace Database\Factories;

use App\Enums\MemberRatingType;
use App\Models\Review;
use App\Models\ReviewRating;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\ReviewRating>
 */
class ReviewRatingFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = ReviewRating::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'review_id' => Review::factory(),
            'rating_type' => $this->faker->randomElement(MemberRatingType::cases()),
            'rating' => $this->faker->numberBetween(1, 5),
        ];
    }
}
