<?php

namespace Database\Factories\User;

use App\Models\User\Contact;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class ContactFactory extends Factory
{
    protected $model = Contact::class;

    public function definition(): array
    {
        return [
            'first_name' => $this->faker->firstName(),
            'last_name' => $this->faker->lastName(),
            'email' => $this->faker->unique()->safeEmail(),
            'phone' => $this->faker->phoneNumber(),
            'newsletter_subscription' => $this->faker->boolean(80), // 80% chance of being subscribed
            'mailing_list' => $this->faker->randomElement(['general', 'newsletter', 'promotions', null]),
            'created_by' => User::inRandomOrder()->first()?->id,
        ];
    }

    public function subscribed(): static
    {
        return $this->state(fn(array $attributes) => [
            'newsletter_subscription' => true,
            'mailing_list' => 'newsletter',
        ]);
    }

    public function unsubscribed(): static
    {
        return $this->state(fn(array $attributes) => [
            'newsletter_subscription' => false,
            'mailing_list' => null,
        ]);
    }
}
