<?php

namespace Database\Factories\User;

use App\Models\User\MemberCategory;
use Illuminate\Database\Eloquent\Factories\Factory;

class MemberCategoryFactory extends Factory
{
    protected $model = MemberCategory::class;

    public function definition(): array
    {
        return [
            'category_name' => fake()->unique()->randomElement([
                'Water testing',
                'Drilling',
                'Pumping',
                'Well repair',
                'Well installation',
                'Well maintenance',
                'Well inspection',
                'Well rehabilitation',
                'Well abandonment',
            ]),
            'category_description' => fake()->paragraph(2),
            'is_active' => true,
        ];
    }
} 