<?php

namespace Database\Factories\User;

use App\Models\Location\City;
use App\Models\Location\Country;
use App\Models\Location\State;
use App\Models\User\User;
use App\Models\User\UserLocation;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class UserLocationFactory extends Factory
{
    protected $model = UserLocation::class;

    public function definition(): array
    {
        // Get random location data
        $country = Country::inRandomOrder()->first();
        $state = $country ? State::where('country_id', $country->id)->inRandomOrder()->first() : null;
        $city = $state ? City::where('state_id', $state->id)->inRandomOrder()->first() : null;

        $countryId = $country ? $country->id : null;
        $stateId = $state ? $state->id : null;
        $cityId = $city ? $city->id : null;

        return [
            'uuid' => Str::uuid(),
            'location_name' => $this->faker->company() . ' Location',
            'contact_person_name' => $this->faker->name(),
            'phone' => $this->faker->phoneNumber(),
            'email' => $this->faker->safeEmail(),
            'fax' => $this->faker->phoneNumber(),
            'map_address' => $this->faker->address(),
            'address_line_1' => $this->faker->streetAddress(),
            'address_line_2' => $this->faker->secondaryAddress(),
            'postal_code' => $this->faker->postcode(),
            'latitude' => $this->faker->latitude(),
            'longitude' => $this->faker->longitude(),
            'is_active' => true,
            'country_id' => $countryId,
            'state_id' => $stateId,
            'city_id' => $cityId,
            'primary_location' => false,
        ];
    }

    /**
     * Configure the location as primary
     */
    public function primary(): static
    {
        return $this->state(function (array $attributes) {
            return [
                'primary_location' => true,
            ];
        });
    }
}
