<?php

namespace Database\Factories\User;

use App\Enums\UserProfileStatus;
use App\Enums\UserProfileType;
use App\Models\User\User;
use App\Models\User\UserProfile;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class UserProfileFactory extends Factory
{
    protected $model = UserProfile::class;

    public function definition(): array
    {
        $profileType = $this->faker->randomElement(UserProfileType::cases());

        $baseData = [
            'uuid' => Str::uuid(),
            'first_name' => $this->faker->firstName(),
            'last_name' => $this->faker->lastName(),
            'credit_balance' => $this->faker->numberBetween(0, 1000),
            'profile_type' => $profileType,
            'about' => $this->faker->paragraphs(3, true),
            'phone' => $this->faker->phoneNumber(),
            'mobile' => $this->faker->phoneNumber(),
            'fax' => $this->faker->phoneNumber(),
            'website' => $this->faker->url(),
            'slogan' => $this->faker->catchPhrase(),
            'status' => UserProfileStatus::Active,
            'service_areas' => [
                $this->faker->state(),
                $this->faker->state(),
                $this->faker->state()
            ],
            'social_media_links' => [
                'facebook' => 'https://facebook.com/' . $this->faker->userName(),
                'twitter' => 'https://twitter.com/' . $this->faker->userName(),
                'linkedin' => 'https://linkedin.com/in/' . $this->faker->userName(),
                'instagram' => 'https://instagram.com/' . $this->faker->userName()
            ]
        ];

        // Add type-specific data based on profile type
        if ($profileType === UserProfileType::Business) {
            $baseData['company_name'] = $this->faker->company();
            $baseData['year_established'] = $this->faker->year();
            $baseData['other_services'] = $this->faker->paragraph();
        }

        return $baseData;
    }
}
