<?php

namespace Database\Factories;

use App\Models\User\User;
use App\Models\Video;
use Illuminate\Database\Eloquent\Factories\Factory;

class VideoFactory extends Factory
{
    protected $model = Video::class;

    public function definition(): array
    {
        return [
            'uuid' => $this->faker->uuid,
            'user_id' => User::factory(),
            'video_title' => $this->faker->sentence(4),
            'video_description' => $this->faker->paragraph(3),
            'video_link' => 'https://www.youtube.com/watch?v=' . $this->faker->regexify('[A-Za-z0-9]{11}'),
            'is_active' => $this->faker->boolean(80),
            'created_by' => function (array $attributes) {
                return $attributes['user_id'];
            },
        ];
    }

    public function inactive(): self
    {
        return $this->state(function () {
            return [
                'is_active' => false,
            ];
        });
    }
} 