<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStatesTable extends Migration
{
    public function up()
    {
        Schema::create('states', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->string('state_name', 191);
            $table->string('slug', 199)->unique();
            $table->string('state_code', 45)->nullable();

            $table->foreignId('country_id')->nullable()
                ->constrained('countries')
                ->cascadeOnDelete()
                ->noActionOnUpdate();

            $table->foreignId('created_by')->nullable()
                ->nullable()
                ->constrained('users')
                ->cascadeOnDelete()
                ->noActionOnUpdate();

            $table->timestamps();
            $table->softDeletes();

            $table->index('slug');
            $table->index('state_name');
        });
    }

    public function down()
    {
        Schema::dropIfExists('states');
    }
}
