<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCitiesTable extends Migration
{
    public function up()
    {
        Schema::create('cities', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->string('city_name', 191);
            $table->string('slug', 100)->unique();

            $table->foreignId('state_id')->nullable()
                ->constrained('states')
                ->cascadeOnDelete()
                ->noActionOnUpdate();

            $table->foreignId('country_id')->nullable()
                ->constrained('countries')
                ->cascadeOnDelete()
                ->noActionOnUpdate();

            $table->foreignId('created_by')->nullable()
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();

            $table->timestamps();
            $table->softDeletes();

            $table->index('slug');
            $table->index('city_name');
        });
    }

    public function down()
    {
        Schema::dropIfExists('cities');
    }
}
