<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCurrenciesTable extends Migration
{
    public function up()
    {
        Schema::create('currencies', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->string('currency_name', 100);
            $table->string('currency_code', 20);
            $table->string('currency_symbol', 10);
            $table->decimal('currency_rate', 10, 3)->nullable();
            $table->boolean('is_active')->default(true);
            $table->boolean('is_default')->default(false);
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->cascadeOnDelete()
                ->noActionOnUpdate();

            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down()
    {
        // Disable foreign key checks to avoid errors when dropping tables with foreign keys
        Schema::disableForeignKeyConstraints();

        Schema::dropIfExists('currencies');

        // Enable foreign key checks again after the operation
        Schema::enableForeignKeyConstraints();
    }
}
