<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserProfilesTable extends Migration
{
    public function up()
    {
        Schema::create('user_profiles', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->foreignId('user_id')
                ->constrained('users')
                ->cascadeOnDelete()
                ->noActionOnUpdate();

            $table->string('first_name', 100);
            $table->string('last_name', 100)->nullable();
            $table->string('company_name', 191)->nullable();
            $table->integer('credit_balance')->default(0);
            $table->string('profile_type', 50)->default('business');
            $table->integer('year_established')->nullable();
            $table->text('credentials')->nullable();
            $table->text('service_areas')->nullable();
            $table->text('about')->nullable();
            $table->string('phone')->nullable();
            $table->string('fax')->nullable();
            $table->text('website')->nullable();
            $table->text('business_hours')->nullable();
            $table->text('social_media_links')->nullable();
            $table->text('slogan')->nullable();
            $table->text('services')->nullable();
            $table->text('other_services')->nullable();
            $table->string('status', 50)->default('active');
            $table->timestamps();
            $table->index('company_name');

            $table->index('profile_type');
            $table->index('status');
        });

        Schema::table('users', function (Blueprint $table) {
            $table->softDeletes();
        });
    }

    public function down()
    {
        Schema::dropIfExists('user_profiles');
        Schema::table('users', function (Blueprint $table) {
            $table->dropSoftDeletes();
        });
    }
}
