<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMembershipPlansTable extends Migration
{
    public function up()
    {
        Schema::create('membership_plans', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->foreignId('role_id')
                ->nullable()
                ->constrained('roles')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->string('package_title', 255);
            $table->string('slug', 255)->unique();
            $table->text('package_description')->nullable();
            $table->string('membership_type', 50)->default('free');
            $table->decimal('price_monthly', 10, 2)->default(0.00);
            $table->decimal('price_quarterly', 10, 2)->default(0.00);
            $table->decimal('price_half_yearly', 10, 2)->default(0.00);
            $table->decimal('price_yearly', 10, 2)->default(0.00);
            $table->string('preferred_payment_term', 50)->default('monthly');
            $table->boolean('is_active')->default(1);
            $table->boolean('is_visible')->default(1);
            $table->boolean('is_featured')->default(0);
            $table->integer('trial_days')->default(0);
            $table->boolean('has_trial')->default(false);
            $table->integer('display_order')->default(0);
            $table->longText('features')->nullable();
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamps();
            $table->softDeletes();

            $table->index('slug');
            $table->index('package_title');
            $table->index('membership_type');
        });
    }

    public function down()
    {
        Schema::dropIfExists('membership_plans');
    }
}
