<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMembershipPlanAdditionalCostsTable extends Migration
{
    public function up()
    {
        Schema::create('membership_plan_additional_costs', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->foreignId('membership_plan_id')
                ->constrained('membership_plans')
                ->cascadeOnDelete()
                ->noActionOnUpdate();
            $table->string('title', 255);
            $table->decimal('price', 10, 2)->default(0.00);
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamps();
            $table->softDeletes();

            $table->index('title');
        });
    }

    public function down()
    {
        Schema::dropIfExists('membership_plan_additional_costs');
    }
}
