<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePackageUserInfoTable extends Migration
{
    public function up()
    {
        Schema::create('package_user_info', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->foreignId('membership_plan_id')
                ->constrained('membership_plans')
                ->cascadeOnDelete()
                ->noActionOnUpdate();
            $table->boolean('show_website_link')->default(1);
            $table->boolean('show_social_media_links')->default(1);
            $table->boolean('show_phone')->default(1);
            $table->boolean('show_address')->default(1);
            $table->boolean('searchable')->default(1);
            $table->boolean('show_public_review')->default(1);
            $table->boolean('show_contact_form')->default(1);
            $table->boolean('show_image_gallery')->default(1);
            $table->integer('image_gallery_limit')->default(1);
            $table->boolean('is_featured')->default(1);
            $table->boolean('show_video_gallery')->default(false);
            $table->integer('video_gallery_limit')->default(0);
            $table->timestamps();
            $table->index('is_featured');
            $table->index('searchable');
        });
    }

    public function down()
    {
        Schema::dropIfExists('package_user_info');
    }
}
