<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePlanModulesTable extends Migration
{
    public function up()
    {
        Schema::create('plan_modules', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->foreignId('membership_plan_id')
                ->constrained('membership_plans')
                ->cascadeOnDelete()
                ->noActionOnUpdate();
            $table->string('module_name', 100);
            $table->integer('module_allowed_images')->default(0);
            $table->boolean('module_allow_listing')->default(1);
            $table->integer('module_listing_limit')->default(0);
            $table->decimal('module_extra_listing_price', 10, 2)->default(0.00);
        });
    }

    public function down()
    {
        Schema::dropIfExists('plan_modules');
    }
}
