<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersMetaTable extends Migration
{
    public function up()
    {
        Schema::create('users_meta', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->foreignId('user_id')
                ->constrained('users')
                ->cascadeOnDelete()
                ->noActionOnUpdate();
            $table->string('type', 45);
            $table->string('key', 255);
            $table->text('value')->nullable();
            $table->timestamps();

            $table->index('key');

        });
    }

    public function down()
    {
        Schema::dropIfExists('users_meta');
    }
}
