<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSubscriptionsTable extends Migration
{
    public function up()
    {
        Schema::create('subscriptions', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->foreignId('user_id')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->foreignId('parent_id')
                ->nullable()
                ->constrained('subscriptions')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->foreignId('membership_plan_id')
                ->nullable()
                ->constrained('membership_plans')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamp('purchase_date');
            $table->string('payment_term', 50)->default('monthly');
            $table->boolean('is_active')->default(1);
            $table->boolean('auto_renewal')->default(1);
            $table->timestamp('current_period_start')->nullable();
            $table->timestamp('current_period_end')->nullable();
            $table->timestamp('trial_ends_at')->nullable();
            $table->timestamp('cancelled_at')->nullable();

            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamps();

            $table->index(['current_period_start', 'current_period_end']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('subscriptions');
    }
}
