<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePurchasesTable extends Migration
{
    public function up()
    {
        Schema::create('purchases', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->string('item_type', 50)->nullable();
            $table->foreignId('user_id')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->string('purchaseable_type', 255)->nullable();
            $table->unsignedBigInteger('purchaseable_id')->nullable();
            $table->date('expire_date')->nullable();
            $table->decimal('amount', 10, 2)->default(0.00);
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamps();
            $table->softDeletes();

            $table->index('item_type');
            $table->index('purchaseable_type');
            $table->index('purchaseable_id');
        });
    }

    public function down()
    {
        Schema::dropIfExists('purchases');
    }
}
