<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePaymentsTable extends Migration
{
    public function up()
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->foreignId('user_id')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->foreignId('purchase_id')
                ->constrained('purchases')
                ->cascadeOnDelete()
                ->noActionOnUpdate();
            $table->string('payment_type', 50)->default('payment');
            $table->string('payment_method', 50)->default('stripe');
            $table->string('transaction_id', 255)->nullable();
            $table->text('service_response')->nullable();
            $table->decimal('amount', 10, 2)->default(0.00);
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamps();
            $table->softDeletes();

            $table->index('payment_type');
            $table->index('payment_method');
            $table->index('user_id');
            $table->index('purchase_id');
        });
    }

    public function down()
    {
        Schema::dropIfExists('payments');
    }
}
