<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInvoicesTable extends Migration
{
    public function up()
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->foreignId('user_id')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->decimal('amount', 10, 2)->default(0.00);
            $table->foreignId('payment_id')
                ->constrained('payments')
                ->cascadeOnDelete()
                ->noActionOnUpdate();
            $table->timestamp('invoice_date');
            $table->string('status', 50)->default('unpaid');
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamps();
            $table->softDeletes();
                
            $table->index('status');
            $table->index('user_id');
            $table->index('payment_id');
        });
    }

    public function down()
    {
        Schema::dropIfExists('invoices');
    }
}
