<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCreditPackagesTable extends Migration
{
    public function up()
    {
        Schema::create('credit_packages', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->string('package_name', 191);
            $table->text('package_description')->nullable();
            $table->decimal('amount', 10, 2)->default(0.00);
            $table->integer('qty')->default(1);
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamps();
            $table->softDeletes();

            $table->index('package_name');
            $table->index('amount');

        });
    }

    public function down()
    {
        Schema::dropIfExists('credit_packages');
    }
}
