<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMemberCategoriesTable extends Migration
{
    public function up()
    {
        Schema::create('member_categories', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->foreignId('parent_id')
                ->nullable()
                ->constrained('member_categories')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->string('category_name', 255);
            $table->text('category_description')->nullable();
            $table->string('slug', 191)->unique();
            $table->string('member_type', 50)->default('member');
            $table->boolean('is_active')->default(1);
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamps();
            $table->softDeletes();

            $table->index('category_name');
            $table->index('member_type');
        });
    }

    public function down()
    {
        Schema::dropIfExists('member_categories');
    }
}
