<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMemberCategoryUserTable extends Migration
{
    public function up()
    {
        Schema::create('member_category_user', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->foreignId('user_id')
                ->constrained('users')
                ->cascadeOnDelete()
                ->noActionOnUpdate();
            $table->foreignId('member_category_id')
                ->constrained('member_categories')
                ->cascadeOnDelete()
                ->noActionOnUpdate();
        });
    }

    public function down()
    {
        Schema::dropIfExists('member_category_user');
    }
}
