<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLeadFormsTable extends Migration
{
public function up()
{
    Schema::create('lead_forms', function (Blueprint $table) {
        $table->bigIncrements('id');
        $table->string('uuid', 255)->unique();
        $table->string('title', 255);
        $table->text('description')->nullable();
        $table->string('match_criteria', 50)->default('category');
        $table->string('reception_mode', 50)->default('manual');
        $table->boolean('enable_captcha')->default(1);
        $table->boolean('is_active')->default(1);
        $table->text('submit_message')->nullable();
        $table->foreignId('created_by')
            ->nullable()
            ->constrained('users')
            ->nullOnDelete()
            ->noActionOnUpdate();
        $table->timestamps();
        $table->softDeletes();
        
        $table->index('uuid');
        $table->index('title');
    });
}

public function down()
{
    Schema::dropIfExists('lead_forms');
}
}
