<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLeadFormVisitsTable extends Migration
{
    public function up()
    {
        Schema::create('lead_form_visits', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->foreignId('lead_form_id')
                ->constrained('lead_forms')
                ->cascadeOnDelete()
                ->noActionOnUpdate();
            $table->text('source');
            $table->string('unique_identifier', 255)->nullable();
            $table->string('ip_address', 100)->nullable();
            $table->string('country', 191)->nullable();
            $table->string('state', 191)->nullable();
            $table->string('city', 191)->nullable();
            $table->timestamp('visit_date');

            $table->index('country');
            $table->index('state');
            $table->index('city');
        });
    }

    public function down()
    {
        Schema::dropIfExists('lead_form_visits');
    }
}
