<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLeadFormFieldsTable extends Migration
{
    public function up()
    {
        Schema::create('lead_form_fields', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->foreignId('lead_form_id')
                ->nullable()
                ->constrained('lead_forms')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->string('field_name', 100);
            $table->string('field_placeholder', 100)->nullable();
            $table->string('field_id', 100);
            $table->string('field_type', 50)->default('text');
            $table->string('data_type', 50)->default('alpha_numeric');
            $table->text('field_options')->nullable();
            $table->string('toggle_yes_text', 100)->nullable();
            $table->string('toggle_no_text', 100)->nullable();
            $table->integer('field_columns')->default(12);
            $table->integer('field_order')->default(1);
            $table->text('help_text')->nullable();
            $table->boolean('is_required')->default(1);
            $table->boolean('is_visible')->default(1);
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down()
    {
        Schema::dropIfExists('lead_form_fields');
    }
}
