<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLeadFormMemberCategoryTable extends Migration
{
    public function up()
    {
        Schema::create('lead_form_member_category', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->foreignId('member_category_id')
                ->constrained('member_categories')
                ->cascadeOnDelete()
                ->noActionOnUpdate();
            $table->foreignId('lead_form_id')
                ->constrained('lead_forms')
                ->cascadeOnDelete()
                ->noActionOnUpdate();
            $table->decimal('price', 10, 2)->default(0.00);
            $table->integer('radius')->default(0);
            
            $table->index('member_category_id');
            $table->index('lead_form_id');
        });
    }

    public function down()
    {
        Schema::dropIfExists('lead_form_member_category');
    }
}
