<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLeadsTable extends Migration
{
    public function up()
    {
        Schema::create('leads', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->foreignId('lead_form_id')
                ->nullable()
                ->constrained('lead_forms')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->text('lead_data');
            $table->text('lead_source')->nullable();
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamps();
            $table->softDeletes();

            $table->index('lead_form_id');

        });
    }

    public function down()
    {
        Schema::dropIfExists('leads');
    }
}
