<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLeadUserTable extends Migration
{
    public function up()
    {
        Schema::create('lead_user', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->foreignId('lead_id')
                ->constrained('leads')
                ->cascadeOnDelete()
                ->noActionOnUpdate();
            $table->foreignId('user_id')
                ->constrained('users')
                ->cascadeOnDelete()
                ->noActionOnUpdate();
            $table->string('lead_status', 100)->default('pending');
        });
    }

    public function down()
    {
        Schema::dropIfExists('lead_user');
    }
}
