<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserCreditHistoryTable extends Migration
{
    public function up()
    {
        Schema::create('user_credit_history', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->foreignId('user_id')
                ->constrained('users')
                ->cascadeOnDelete()
                ->noActionOnUpdate();
            $table->integer('debit')->default(0);
            $table->integer('credit')->default(0);
            $table->integer('balance')->default(0);
            $table->string('creditable_type', 255)->nullable();
            $table->unsignedBigInteger('creditable_id')->nullable();
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamps();
            $table->softDeletes();

            $table->index('user_id');
            $table->index('creditable_type');
            $table->index('creditable_id');
        });
    }

    public function down()
    {
        Schema::dropIfExists('user_credit_history');
    }
}
