<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Enums\ClassifiedStatus;

class CreateClassifiedsTable extends Migration
{
    public function up()
    {
        Schema::create('classifieds', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->foreignId('user_id')
                ->constrained('users')
                ->cascadeOnDelete()
                ->noActionOnUpdate();
            $table->string('title', 255);
            $table->text('description')->nullable();
            $table->string('slug', 255)->unique();
            $table->decimal('price', 10, 2)->default(0.00);
            $table->text('website_link')->nullable();
            $table->boolean('is_featured')->default(0);
            $table->text('location')->nullable();
            $table->text('address')->nullable();
            $table->string('classified_status')->default(ClassifiedStatus::Draft->value);
            $table->foreignId('city_id')
                ->nullable()
                ->constrained('cities')
                ->nullOnDelete();
            $table->foreignId('state_id')
                ->nullable()
                ->constrained('states')
                ->nullOnDelete();
            $table->foreignId('country_id')
                ->nullable()
                ->constrained('countries')
                ->nullOnDelete();
            $table->string('postal_code', 100)->nullable();
            $table->string('latitude', 100)->nullable();
            $table->string('longitude', 100)->nullable();
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamp('published_at')->nullable();
            $table->timestamp('expired_at')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->index('title');
            $table->index('city_id');
            $table->index('state_id');
            $table->index('country_id');
            $table->index('created_by');
        });
    }

    public function down()
    {
        Schema::dropIfExists('classifieds');
    }
}
