<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClassifiedCategoriesTable extends Migration
{
    public function up()
    {
        Schema::create('classified_categories', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->foreignId('parent_id')
                ->nullable()
                ->constrained('classified_categories')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->string('classified_category_name', 191);
            $table->text('classified_category_description')->nullable();
            $table->string('slug', 191)->unique();
            $table->boolean('is_active')->default(1);
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamps();
            $table->softDeletes();

            $table->index('classified_category_name');
            $table->index('slug');
            $table->index(['deleted_at', 'classified_category_name']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('classified_categories');
    }
}
