<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClassifiedTagsTable extends Migration
{
    public function up()
    {
        Schema::create('classified_tags', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->string('classified_tag_name', 191);
            $table->boolean('is_active')->default(1);
            $table->string('slug')->unique();
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamps();
            $table->softDeletes();
            
            $table->index('classified_tag_name');
        });
    }

    public function down()
    {
        Schema::dropIfExists('classified_tags');
    }
}
