<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClassifiedTypesTable extends Migration
{
    public function up()
    {
        Schema::create('classified_types', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->foreignId('parent_id')
                ->nullable()
                ->constrained('classified_types')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->string('classified_type_name', 191);
            $table->text('classified_type_description')->nullable();
            $table->string('slug', 191)->unique();
            $table->boolean('is_active')->default(1);
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamps();
            $table->softDeletes();
            
            $table->index('classified_type_name');
        });
    }

    public function down()
    {
        Schema::dropIfExists('classified_types');
    }
}
