<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClassifiedClassifiedCategoryTable extends Migration
{
    public function up()
    {
        Schema::create('classified_classified_category', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->foreignId('classified_category_id')
                ->constrained('classified_categories')
                ->cascadeOnDelete();
            $table->foreignId('classified_id')
                ->constrained('classifieds')
                ->cascadeOnDelete();

            $table->index(['classified_category_id']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('classified_classified_category');
    }
}
