<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePostsTable extends Migration
{
    public function up()
    {
        Schema::create('posts', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->string('post_title', 255);
            $table->longText('post_description')->nullable();
            $table->text('post_excerpt')->nullable();
            $table->string('slug', 255)->unique();
            $table->string('post_status', 20)->default('draft');
            $table->boolean('is_featured')->default(false);
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamp('published_at')->nullable();
            $table->timestamp('expired_at')->nullable();
            $table->timestamps();
            $table->softDeletes();

            // Indexes
            $table->index('post_title');
            $table->index('slug');
            $table->index('post_status');
            $table->index(['post_status', 'published_at']);
            $table->index(['post_status', 'deleted_at']);
            $table->index('deleted_at');
            $table->index('created_at');
        });
    }

    public function down()
    {
        Schema::dropIfExists('posts');
    }
} 