<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePostPostTagTable extends Migration
{
    public function up()
    {
        Schema::create('post_post_tag', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->foreignId('post_id')
                ->constrained('posts')
                ->cascadeOnDelete();
            $table->foreignId('post_tag_id')
                ->constrained('post_tags')
                ->cascadeOnDelete();
            $table->timestamps();

            $table->index(['post_tag_id']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('post_post_tag');
    }
} 