<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePostPostCategoryTable extends Migration
{
    public function up()
    {
        Schema::create('post_post_category', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->foreignId('post_id')
                ->constrained('posts')
                ->cascadeOnDelete();
            $table->foreignId('post_category_id')
                ->constrained('post_categories')
                ->cascadeOnDelete();
            $table->timestamps();

            $table->index(['post_category_id']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('post_post_category');
    }
} 