<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTeamMembersTable extends Migration
{
    public function up()
    {
        Schema::create('team_members', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->foreignId('user_id')
                ->constrained('users')
                ->cascadeOnDelete();
            $table->string('first_name', 100);
            $table->string('last_name', 100)->nullable();
            $table->string('phone', 100)->nullable();
            $table->string('email', 100)->nullable();
            $table->string('experience_years', 100)->nullable();
            $table->text('credentials')->nullable();
            $table->text('description')->nullable();
            $table->text('address')->nullable();
            $table->text('social_links')->nullable();
            $table->string('team_member_status', 20)->default('draft');
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamp('published_at')->nullable();
            $table->timestamp('expired_at')->nullable();
            $table->timestamps();
            $table->softDeletes();

            // Indexes
            $table->index('team_member_status');
            $table->index(['team_member_status', 'published_at']);
            $table->index(['team_member_status', 'deleted_at']);
            $table->index('deleted_at');
            $table->index('created_at');
        });
    }

    public function down()
    {
        Schema::dropIfExists('team_members');
    }
}
