<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProjectTypesTable extends Migration
{
    public function up()
    {
        Schema::create('project_types', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->foreignId('parent_id')
                ->nullable()
                ->constrained('project_types')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->string('type_name', 255);
            $table->string('slug', 255)->unique();
            $table->text('type_description')->nullable();
            $table->boolean('is_active')->default(1);
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamps();
            $table->softDeletes();

            $table->index('type_name');

        });
    }

    public function down()
    {
        Schema::dropIfExists('project_types');
    }
}
