<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProjectsTable extends Migration
{
    public function up()
    {
        Schema::create('projects', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->foreignId('parent_id')
                ->nullable()
                ->constrained('projects')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->foreignId('user_id')
                ->constrained('users')
                ->cascadeOnDelete();
            $table->string('title', 255);
            $table->string('slug', 255)->unique();
            $table->text('description')->nullable();
            $table->text('address')->nullable();
            $table->text('techniques')->nullable();
            $table->text('equipments')->nullable();
            $table->text('introduction')->nullable();
            $table->text('objective')->nullable();
            $table->text('challenges')->nullable();
            $table->text('solutions')->nullable();
            $table->text('outcomes')->nullable();
            $table->string('project_status', 20)->default('draft');
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamp('published_at')->nullable();
            $table->timestamp('expired_at')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->index('title');
            $table->index('slug');
            $table->index('project_status');
            $table->index(['project_status', 'published_at']);
            $table->index(['project_status', 'deleted_at']);
            $table->index('deleted_at');
            $table->index('created_at');
        });
    }

    public function down()
    {
        Schema::dropIfExists('projects');
    }
}
