<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProjectProjectTypeTable extends Migration
{
    public function up()
    {
        Schema::create('project_project_type', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->foreignId('project_id')
                ->constrained('projects')
                ->cascadeOnDelete();
            $table->foreignId('project_type_id')
                ->constrained('project_types')
                ->cascadeOnDelete();
        });
    }

    public function down()
    {
        Schema::dropIfExists('project_project_type');
    }
}
