<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductsTable extends Migration
{
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->foreignId('parent_id')
                ->nullable()
                ->constrained('products')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->string('product_title', 255);
            $table->string('slug', 255)->unique();
            $table->text('product_description')->nullable();
            $table->string('product_sku', 255)->nullable();
            $table->text('link')->nullable();
            $table->integer('quantity')->default(0);
            $table->decimal('price', 10, 2)->default(0.00);
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamp('published_at')->nullable();
            $table->timestamp('expired_at')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->index('product_title');
            $table->index('product_sku');
        });
    }

    public function down()
    {
        Schema::dropIfExists('products');
    }
}
