<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateReviewsTable extends Migration
{
    public function up()
    {
        Schema::create('reviews', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->integer('review_rating')->default(1);
            $table->string('review_title', 255);
            $table->text('review_content');
            $table->foreignId('review_user_id')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->string('reviewable_type', 255)->nullable();
            $table->unsignedBigInteger('reviewable_id')->nullable();
            $table->boolean('status')->default(1);
            $table->timestamps();
            $table->softDeletes();

            $table->index('review_title');
            $table->index('review_rating');
            $table->index('reviewable_type');
            $table->index('reviewable_id');
        });
    }

    public function down()
    {
        Schema::dropIfExists('reviews');
    }
}
