<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserLocationsTable extends Migration
{
    public function up()
    {
        Schema::create('user_locations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->string('location_name', 191);
            $table->string('contact_person_name', 191)->nullable();
            $table->string('phone', 100);
            $table->string('email', 191);
            $table->string('fax', 100);
            $table->text('map_address')->nullable();
            $table->text('address_line_1');
            $table->text('address_line_2')->nullable();
            $table->string('postal_code', 191)->nullable();
            $table->string('latitude', 100)->nullable();
            $table->string('longitude', 100)->nullable();
            $table->boolean('is_active')->default(1);
            $table->foreignId('user_id')
                ->constrained('users')
                ->cascadeOnDelete();
            $table->foreignId('city_id')
                ->nullable()
                ->constrained('cities')
                ->nullOnDelete();
            $table->foreignId('state_id')
                ->nullable()
                ->constrained('states')
                ->nullOnDelete();
            $table->foreignId('country_id')
                ->nullable()
                ->constrained('countries')
                ->nullOnDelete();
            $table->boolean('primary_location')->default(0);
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamps();
            $table->softDeletes();

            $table->index('location_name');
            $table->index('phone');
            $table->index('email');
        });
    }

    public function down()
    {
        Schema::dropIfExists('user_locations');
    }
}
