<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateJobRolesTable extends Migration
{
    public function up()
    {
        Schema::create('job_roles', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->foreignId('parent_id')
                ->nullable()
                ->constrained('job_roles')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->string('job_role_name', 191);
            $table->string('slug', 191)->unique();
            $table->text('job_role_description')->nullable();
            $table->boolean('is_active')->default(1);
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamps();
            $table->softDeletes();

            $table->index('job_role_name');

        });
    }

    public function down()
    {
        Schema::dropIfExists('job_roles');
    }
}
