<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateJobCareerLevelTable extends Migration
{
    public function up()
    {
        Schema::create('job_career_level', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->foreignId('parent_id')
                ->nullable()
                ->constrained('job_career_level')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->string('career_level_name', 191);
            $table->text('career_level_description')->nullable();
            $table->string('slug', 191)->unique();
            $table->boolean('is_active')->default(1);
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamps();
            $table->softDeletes();

            $table->index('career_level_name');

        });
    }

    public function down()
    {
        Schema::dropIfExists('job_career_level');
    }
}
