<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateJobIndustriesTable extends Migration
{
    public function up()
    {
        Schema::create('job_industries', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->foreignId('parent_id')
                ->nullable()
                ->constrained('job_industries')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->string('industry_name', 191);
            $table->text('industry_description')->nullable();
            $table->string('slug', 191)->unique();
            $table->boolean('is_active')->default(1);
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamps();
            $table->softDeletes();

            $table->index('industry_name');

        });
    }

    public function down()
    {
        Schema::dropIfExists('job_industries');
    }
}
