<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateJobTypesTable extends Migration
{
    public function up()
    {
        Schema::create('job_types', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->foreignId('parent_id')
                ->nullable()
                ->constrained('job_types')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->string('job_type_name', 255);
            $table->text('job_type_description')->nullable();
            $table->string('slug', 191)->unique();
            $table->boolean('is_active')->default(1);
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamps();
            $table->softDeletes();

            $table->index('job_type_name');

        });
    }

    public function down()
    {
        Schema::dropIfExists('job_types');
    }
}
