<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateJobsTable extends Migration
{
    public function up()
    {
        Schema::create('jobs', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->string('job_title', 255);
            $table->string('slug', 191);
            $table->text('job_description');
            $table->foreignId('user_id')
                ->constrained('users')
                ->cascadeOnDelete();
            $table->foreignId('job_role_id')
                ->nullable()
                ->constrained('job_roles')
                ->nullOnDelete();
            $table->foreignId('job_industry_id')
                ->nullable()
                ->constrained('job_industries')
                ->nullOnDelete();
            $table->foreignId('job_career_level_id')
                ->nullable()
                ->constrained('job_career_level')
                ->nullOnDelete();
            $table->foreignId('job_type_id')
                ->nullable()
                ->constrained('job_types')
                ->nullOnDelete();
            $table->integer('available_positions')->default(1);
            $table->string('preferred_gender', 20)->nullable();
            $table->integer('min_salary')->nullable();
            $table->integer('max_salary')->nullable();
            $table->foreignId('currency_id')
                ->nullable()
                ->constrained('currencies')
                ->nullOnDelete();
            $table->string('salary_period', 50)->nullable();
            $table->string('job_shift', 50)->nullable();
            $table->date('apply_by_date')->nullable();
            $table->boolean('deactivate_apply_by')->default(1);
            $table->text('key_responsibilities')->nullable();
            $table->text('required_qualifications')->nullable();
            $table->text('bonus_and_benefits')->nullable();
            $table->boolean('is_featured')->default(false);
            $table->foreignId('country_id')
                ->nullable()
                ->constrained('countries')
                ->nullOnDelete();
            $table->foreignId('state_id')
                ->nullable()
                ->constrained('states')
                ->nullOnDelete();
            $table->foreignId('city_id')
                ->nullable()
                ->constrained('cities')
                ->nullOnDelete();
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->foreignId('updated_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamp('published_at')->nullable();
            $table->timestamp('expired_at')->nullable();
            $table->boolean('is_active')->default(true);
            $table->string('job_status', 20)->default('draft');
            $table->timestamps();
            $table->softDeletes();

            $table->index('job_title');
            $table->index('slug');
            $table->index('salary_period');
            $table->index('job_shift');
            $table->index('country_id');
            $table->index('state_id');
            $table->index('city_id');

            $table->index('job_status');
            $table->index(['job_status', 'published_at']);
            $table->index(['job_status', 'deleted_at']);
            $table->index('deleted_at');
            $table->index('created_at');
        });
    }

    public function down()
    {
        // Disable foreign key checks to avoid errors when dropping tables with foreign keys
        Schema::disableForeignKeyConstraints();

        Schema::dropIfExists('jobs');

        // Enable foreign key checks again after the operation
        Schema::enableForeignKeyConstraints();
    }
}
